#ifndef CSETTINGS_H
#define CSETTINGS_H

#include <map>
#include <vector>
#include "CString.h"

typedef std::map<CString, CString> StringMap;

class CSettings
{
	public:
		// Constructor-Destructor
		CSettings();
		CSettings(const CString& pStr, const CString& pSeparator = "=");

		// File-Loading Functions
		bool loadFile(const CString& pStr);

		// Get Type
		bool getBool(const CString& pKeyName, bool pDefault = true);
		float getFloat(const CString& pKeyName, float pDefault = 1.00);
		int getInt(const CString& pKeyName, int pDefault = 1);
		const CString& getStr(const CString& pKeyName, const CString& pDefault = "");

		//! Checks if the settings have been loaded
		//! \return bool - true/false if settings have loaded
		bool IsOpened()
		{
			return mIsOpened;
		}

		//! Checks if a key exists in the map.
		//! \return bool - true/false if key exists
		bool KeyExists(const CString& pKeyName)
		{
			return (GetKey(pKeyName) != mKeyList.end());
		}

		//! Gets an iterator to a key.
		//! \return The iterator with the associated key.
		StringMap::iterator GetKey(const CString& pKeyName)
		{
			return mKeyList.find(pKeyName.toLower());
		}
		
		//! Gets a map full of the key names/values.
		//! \return The Key List.
		StringMap * GetKeyList()
		{
			return &mKeyList;
		}

		//! Sets the new setting separator
		//! \param separator Setting Separator
		void SetSeparator(const CString& pSeparator = "=")
		{
			mStrSep = pSeparator;
		}

	private:
		bool mIsOpened;
		CString mStrSep;
		StringMap mKeyList;
		std::vector<CString> strList;
};

#endif // CSETTINGS_H
