#ifndef TGRAALDATABASE_H
#define TGRAALDATABASE_H

#include "CSettings.h"
#include "CString.h"

extern CString CalculateMD5(const CString& buffer);
typedef std::map<CString, CString> SqlRow, STRMAP;
typedef std::vector<STRMAP> SqlResult;

enum // Account Status
{
	ACCSTAT_NORMAL		= 0,
	ACCSTAT_NONREG		= 1,
	ACCSTAT_BANNED		= 2,
	ACCSTAT_INVALID		= 3,
};

enum // Create Account Errors
{
	CRACCT_INVACCT		= 0,
	CRACCT_INVPASS		= 1,
	CRACCT_EXISTS		= 2,
	CRACCT_SUCCESS		= 3,
};

enum // Guild Status
{
	GUILDSTAT_DISALLOWED	= 0,
	GUILDSTAT_ALLOWED		= 1,
};

class TGraalDatabase
{
	public:
		// Constructor | Destructor
		TGraalDatabase(CSettings *pSettings) { mSettings = pSettings; }
		virtual ~TGraalDatabase() { }

		// Override Functions
		virtual int Initiate() = 0;

		// Account Management
		virtual bool AccountExists(const CString& pAccountName) = 0;
		virtual int CreateAccount(const CString& pAccountName, const CString& pPassword) = 0;
		virtual int VerifyAccount(CString& pAccountName, const CString& pPassword, bool pFromServer) = 0;
		virtual int VerifyGuild(const CString& pGuildName, const CString& pAccountName, const CString& pNickName) = 0;
		virtual int VerifyIpBan(const CString& pIpAddress, int pType) = 0;

		// Profile Management
		virtual int GetProfile(const CString& pAccountName, CString& pPacket) = 0;
		virtual int SetProfile(const CString& pAccountName, CString& pPacket) = 0;

		// Server Management
		virtual int AddServerToList(const CString& pServerName)		{ return 1; };
		virtual int DelServerFromList(const CString& pServerName)	{ return 1; };

		static public void Output_SqlResult(SqlResult Result)
		{
			int row = 0;
			for (SqlResult::iterator i = Result.begin(); i != Result.end(); ++i)
			{
				printf("Row %i\n", row++);
				for (SqlRow::iterator j = (*i).begin(); j != (*i).end(); ++j)
					printf("	Field %s -> %s\n", (*j).first.text(), (*j).second.text());
			}

		}

	protected:
		CSettings *mSettings;
		CString GenerateHash(int length);
};

#endif
