#ifndef TGRAALPLAYER_H
#define TGRAALPLAYER_H

#include "CCodec.h"
#include "CSocket.h"
#include "CString.h"

/*
enum
{
	PLI_V1VER			= 0,
	PLI_SERVERLIST		= 1,
	PLI_V2VER			= 4,
	PLI_V2SERVERLISTRC	= 5,
	PLI_V2ENCRYPTKEYCL	= 7,
	PLI_GRSECURELOGIN	= 223		// GR created function.
};

enum
{
	PLO_SVRLIST			= 0,
	PLO_NULL			= 1,
	PLO_STATUS			= 2,
	PLO_SITEURL			= 3,
	PLO_ERROR			= 4,
	PLO_UPGURL			= 5,
	PLO_GRSECURELOGIN	= 223
};
*/

enum // Player Packets (Player -> Server)
{
	PLI_PRE22			= 0,
	PLI_LOGIN			= 1,
	PLI_VER22			= 4,
	PLI_V2SERVERLISTRC	= 5,
	PLI_POST22			= 7,
	PLI_ADMINLOGIN		= 200,
	PLI_GRSECURELOGIN	= 223		// GR created function.
};

enum // Server Packets (Server -> Player)
{
	PLO_SVRLIST			= 0,
	PLO_NULL			= 1,
	PLO_STATUS			= 2,
	PLO_SITEURL			= 3,
	PLO_ERROR			= 4,
	PLO_UPGURL			= 5,
	PLO_GRSECURELOGIN	= 223
};

enum // Player Type
{
	PLTYPE_INVALID	= 0,
	PLTYPE_NEWMAIN1	= 1,
	PLTYPE_NEWMAIN2	= 2,
	PLTYPE_CONTROL1	= 3,
	PLTYPE_CONTROL2	= 4,
	PLTYPE_ADMNCTRL	= 9,
};

class TServerList;
class TGraalPlayer : public CSocketStub
{
	public:
		// Constructor | Destructor
		TGraalPlayer(TServerList *pServerList, CSocket *pSocket);
		~TGraalPlayer();

		// Functions -> Socket
		bool onRecv();
		bool onSend();
		bool canRecv()				{ return (mSocket->getState() != SOCKET_STATE_DISCONNECTED); }
		bool canSend()				{ return (!mDataOut.isEmpty()); }
		bool onRegister()			{ return true; }
		void onUnregister();
		SOCKET getSocketHandle()	{ return mSocket->getHandle(); }
		unsigned int send(CString pBuffer);

		// Functions -> Main
		//void SendServerList();

		// Functions -> Packet Manipulation
		void DecryptPacket(CString& pPacket);
		bool ParsePacket(CString& pPacket);
		void SendCompress();
		void SendPacket(CString pPacket, bool pFlush = false);
		void SetCodec(int pEncryption, int pKey = 0);
		
		// Functions -> Packet
		static bool IsCreated;
		static void CreateFunctions();

		bool msgPLI_NULL(CString& pPacket);
		bool msgPLI_PRE22(CString& pPacket);
		bool msgPLI_LOGIN(CString& pPacket);
		bool msgPLI_VER22(CString& pPacket);
		bool msgPLI_POST22(CString& pPacket);

		// Admin Functions
		bool msgPLI_ADMINLOGIN(CString& pPacket);

	protected:
		CCodec mCodecIn, mCodecOut;
		CSocket *mSocket;
		CString mDataIn, mDataOut;
		TServerList *mServerList;

		CString mGraalVersion;
		int mPlayerType;
};

#endif
