#ifndef TGRAALSERVER_H
#define TGRAALSERVER_H

#include "CSocket.h"
#include "CString.h"

class player;
class TServerList;
class TGraalServer : public CSocketStub
{
	public:
		// Constructor | Destructor
		TGraalServer(TServerList *pServerList, CSocket *pSocket);
		~TGraalServer();

		// Functions -> Socket
		bool onRecv();
		bool onSend();
		bool canRecv()				{ return (mSocket->getState() != SOCKET_STATE_DISCONNECTED); }
		bool canSend()				{ return (!mDataOut.isEmpty()); }
		bool onRegister()			{ return true; }
		void onUnregister();
		SOCKET getSocketHandle()	{ return mSocket->getHandle(); }
		unsigned int send(CString pBuffer);

		// Functions -> Packet Manipulation
		bool ParsePacket(CString& pPacket);
		void SendCompress();
		void SendPacket(CString pPacket, bool pFlush = false);

		// Functions -> idk
		CString GetServerPacket(int pGraalVersion, const CString& pIp = "");
		const CString& GetDescription()	{ return mServerDesc; }
		const CString& GetIp()			{ return mServerIp;	  }
		const CString& GetLanguage()	{ return mServerLang; }
		const CString& GetName()		{ return mServerName; }
		const CString& GetPort()		{ return mServerPort; }
		const CString& GetUrl()			{ return mServerUrl;  }
		const CString& GetVersion()		{ return mServerVers; }

		// Functions -> Packet
		static bool IsCreated;
		static void CreateFunctions();

		bool msgPLI_NULL(CString& pPacket);

	protected:
		CSocket *mSocket;
		CString mDataIn, mDataOut;
		TServerList *mServerList;

		CString mServerDesc, mServerLang, mServerName, mServerUrl;
		CString mServerIp, mServerPort, mServerVers;
		std::vector<player *> mPlayerList;
};

#endif
