#ifndef TSERVERLIST_H
#define TSERVERLIST_H

#include <vector>
#include "CSettings.h"
#include "CSocket.h"
#include "TGraalDatabase.h"
#include "TServerSocket.h"

class TGraalDatabase;
class TGraalPlayer;
class TGraalServer;

enum // Socket Type
{
	SOCK_PLAYER			= 0,
	SOCK_SERVER			= 1,
	SOCK_PLAYEROLD		= 2,
};

class TServerList
{
	public:
		// Constructor - Destructor
		TServerList(CSettings *pSettings = 0);
		~TServerList();

		// Main Functions
		bool run();
		int initiate(CSettings *pSettings);
		void AddSocket(CSocket *pNewSocket, int pType = SOCK_PLAYER);
		void RemoveSocket(CSocketStub *pSocketStub, int pType = SOCK_PLAYER);

		// Player-Management
		CString GetServerList(int pGraalVersion, const CString& pIp = "");
		int GetServerCount() { return (int)mServerList.size(); }

		// Serverlist Management
		int CreateAccount(CString& pAccountName, const CString& pPassword);
		int VerifyAccount(CString& pAccountName, const CString& pPassword, bool pFromServer = false);
		int VerifyGuild(const CString& pGuildName, const CString& pAccountName, const CString& pNickName);
		int VerifyIpBan(const CString& pIpAddress, int pType = SOCK_PLAYER);

		//! Returns the Serverlist Settings
		//! \return CSettings - Settings Object
		CSettings * GetSettings()
		{
			return mSettings;
		}

	protected:
		CSettings *mSettings;
		CSocketManager mSocketManager;
		TGraalDatabase *mGraalDatabase;
		TServerSocket mPlayerSocket, mServerSocket;
		std::vector<TGraalPlayer *> mPlayerList;
		std::vector<TGraalServer *> mServerList;
};

#endif
