#ifdef DATABASE_MYSQL
#ifndef TSQLDATABASE_H
#define TSQLDATABASE_H

#include "TGraalDatabase.h"

#ifdef _WIN32
	#define my_socket_defined
	#define my_socket int
#endif
#include "mysql/mysql.h"

class TSqlDatabase : public TGraalDatabase
{
	public:
		TSqlDatabase(CSettings *pSettings) : TGraalDatabase(pSettings) { mMySql = 0; }
		int Initiate();
		
		// Account Management
		bool AccountExists(const CString& pAccountName);
		int CreateAccount(const CString& pAccountName, const CString& pPassword);
		int VerifyAccount(CString& pAccountName, const CString& pPassword, bool pFromServer);
		int VerifyGuild(const CString& pGuildName, const CString& pAccountName, const CString& pNickName);
		int VerifyIpBan(const CString& pIpAddress, int pType);

		// Profile Management
		int GetProfile(const CString& pAccountName, CString& pPacket);
		int SetProfile(const CString& pAccountName, CString& pPacket);

	protected:
		bool connect(const CString& pServer, const CString& pUsername, const CString& pPassword, const CString& pDatabase, const CString& pExt);
		bool ping();
		const char * error();

		int query(const CString& pQuery, std::vector<STRMAP> *pResult);
		bool result_get(MYSQL_RES *result, MYSQL_ROW row, MYSQL_FIELD *pFields, STRMAP *pResult);
		void result_output(std::vector<STRMAP> *pResult);

		CString mServer, mUsername, mPassword, mDatabase, mExternal;
		MYSQL *mMySql;
};

#endif
#endif