#ifndef TSQLITEDATABASE_H
#define TSQLITEDATABASE_H

#include "TGraalDatabase.h"

#include "sqlite3.h"

class TSqliteDatabase : public TGraalDatabase
{
	public:
		TSqliteDatabase(CSettings *pSettings) : TGraalDatabase(pSettings) { mDatabase = 0; }
		int Initiate();
		void CreateDatabase();
		
		// Account Management
		bool AccountExists(const CString& pAccountName) { return false; }
		int CreateAccount(const CString& pAccountName, const CString& pPassword);
		int VerifyAccount(CString& pAccountName, const CString& pPassword, bool pFromServer);
		int VerifyGuild(const CString& pGuildName, const CString& pAccountName, const CString& pNickName) { return 0; }
		int VerifyIpBan(const CString& pIpAddress, int pType) { return 0; }

		// Profile Management
		int GetProfile(const CString& pAccountName, CString& pPacket) { return 0; }
		int SetProfile(const CString& pAccountName, CString& pPacket) { return 0; }

	protected:
		const char * error();
		int connect(const CString& pDatabaseFile);
		int query(const CString& pQuery, SqlResult *pResult);
		inline int query(const CString& pQuery) { return this->query(pQuery, 0); }

		CString mDatabaseFile;
		sqlite3 *mDatabase;
};

#endif
