#include "TServerSocket.h"
#include "TServerList.h"

TServerSocket::TServerSocket(TServerList *pServerList)
{
	this->mServerList = pServerList;
}

bool TServerSocket::onRecv()
{
	CSocket *newSocket = mSocket.accept();
	if (newSocket == 0)
		return true;

	mServerList->AddSocket(newSocket, mSocketType);
	return true;
}

int TServerSocket::initiate(const char *pPort, const char *pDescription, int pSocketType)
{
	mSocket.setType(SOCKET_TYPE_SERVER);
	mSocket.setProtocol(SOCKET_PROTOCOL_TCP);
	mSocket.setDescription(pDescription);
	if (mSocket.init(0, pPort))
		return 1;
	if (mSocket.connect())
		return 2;
	mSocketType = pSocketType;
	return 0;
}