#include <stdio.h>
#include "main.h"
#include "TServerList.h"

//#pragma comment(lib, "mysqlclient")

CString homepath;

int main(int argc, char *argv[])
{
	// Working Directory
	homepath = getDirName(argv[0]);

	// Settings Directory
	CSettings SettingsFile("settings.ini");
	if (!SettingsFile.IsOpened())
	{
		printf("[ Error ]: Invalid Settings File!\n");
		return -1;
	}

	// Create Serverlist
	TServerList ServerList(&SettingsFile);
	
	// Run Serverlist
	while (ServerList.run());

	// Return
	return 0;
}

/*
	Extra-Cool Functions :D
*/
CString GetAccountError(int pErrorId)
{
	switch (pErrorId)
	{
		case ACCSTAT_NORMAL:
			return "SUCCESS";

		case ACCSTAT_NONREG:
			return "Your account is not activated.";

		case ACCSTAT_BANNED:
			return "Your account is globally banned.";

		case ACCSTAT_INVALID:
			return "An account with the name or password you typed in does not exist.";

		default:
			return "Invalid Error Id";
	}
}